(proclaim '(optimize (compilation-speed 0) (debug 0) (safety 0) (space 1) (speed 3)))
(load "compiler-settings.lisp" :if-does-not-exist nil)

(compile-file "dbmc-structs.lisp")
(load "dbmc-structs")
(compile-file "helper-functions.lisp")
(load "helper-functions")
(compile-file "syntax-check.lisp")
(load "syntax-check")
(compile-file "type-check.lisp")
(load "type-check")
(compile-file "heap")
(load "heap")
(compile-file "simplify.lisp")
(load "simplify")
(compile-file "and-propagation")
(load "and-propagation")
(compile-file "unroll.lisp")
(load "unroll")
(compile-file "memories.lisp")
(load "memories")
(compile-file "cnf.lisp")
(load "cnf")
(compile-file "top-level-functions.lisp")
(load "top-level-functions")
(compile-file "smt.lisp")
(compile-file "bat.lisp")

(run-shell-command "rm -rf bat-smt")
(run-shell-command "rm -rf bat")

(generate-executable "bat-smt" '("cnf.fasl"
				 "dbmc-structs.fasl"
				 "heap.fasl"
				 "helper-functions.fasl"
				 "memories.fasl"
				 "simplify.fasl"
				 "and-propagation.fasl"
				 "syntax-check.fasl"
				 "top-level-functions.fasl"
				 "type-check.fasl"
				 "unroll.fasl"
				 "smt.fasl"))

(generate-executable "bat" '("cnf.fasl"
                             "dbmc-structs.fasl"
                             "heap.fasl"
                             "helper-functions.fasl"
                             "memories.fasl"
                             "simplify.fasl"
			     "and-propagation.fasl"
                             "syntax-check.fasl"
                             "top-level-functions.fasl"
                             "type-check.fasl"
                             "unroll.fasl"
                             "bat.fasl"))
